<?php
include_once "../inc/start.php";
include_once "../inc/protect.php";

if(empty($_POST['phpaction'])) {
	log_error("Прямой вызов actions.php");
	exit('Ошибка: [Прямой вызов инклуда]');
}

if($conf->token == 1 && ($_SESSION['token'] != clean($_POST['token'], null))) {
	log_error("Неверный токен");
	exit('Ошибка: [Неверный токен]');
}

$method = empty($_POST['method']) ? false : $_POST['method'];

if(!$method) {
	exit('Ошибка: [Метод не объявлен!]');
}

if(!is_auth()) {
	exit('Ошибка: [Вы не авторизованы]');
}

if( $method == 'poll_answer' )
{
	$pollid = checkJs($_POST['pollid'], "int");
	$answer = checkJs($_POST['answer'], "int");
	$pool_type = checkJs($_POST['pool_type'], null);
	
	if(empty($pollid)) {
		exit (json_encode(array('status' => '2', 'data' => 'Опрос не существует')));
	}
	
	if(empty($pool_type)) {
		exit (json_encode(array('status' => '2', 'data' => 'Тип не указан')));
	}
	
	if(empty($answer)) {
		exit (json_encode(array('status' => '2', 'data' => 'Вы не выбрали ответ')));
	}
	
	$STH = $pdo->query("SELECT `id` FROM `poll` WHERE `id` = {$pollid} LIMIT 1");
	if( !($STH->fetch()) ) {
		exit (json_encode(array('status' => '2', 'data' => 'Опрос не существует')));
	}
	
	$STH = $pdo->query("SELECT `id` FROM `poll_answer` WHERE `pollid` = {$pollid} AND `userid`={$_SESSION['id']}");
	if($STH->fetch()) {
		exit (json_encode(array('status' => '2', 'data' => 'Вы уже участвовали в данном опросе')));
	}
	
	require_once('../inc/classes/class.polls.php');
	$tpl = new Template;
	$pools = new Polls($pdo, $tpl, '../modules/polls/tpl/');
	
	if( method_exists($pools, $pool_type) )
	{
		if( $pdo->query("INSERT INTO `poll_answer`(`userid`, `pollid`, `poll`) VALUES ( {$_SESSION['id']}, {$pollid}, {$answer})") )
		{
			exit (json_encode(array('status' => '1', 'data' => $pools->$pool_type($pollid) )));
		}
	}
	
	
	exit (json_encode(array('status' => '2', 'data' => 'Не удалось засчитать ваше участие в опросе, повторите попытку позже')));
}

if(!is_admin()) {
	exit('Ошибка: [Доступно только администраторам]');
}

if( $method == 'poll_dell_function' )
{
	$pollid = checkJs($_POST['pollid'], "int");
	if(empty($pollid)) {
		exit (json_encode(array('status' => '2', 'data' => 'Не корректно выбран опрос')));
	}
	
	if( $pdo->query("DELETE FROM `poll` WHERE `id` = {$pollid}") )
	{
		exit (json_encode(array('status' => '1', 'data' => 'Удалено')));
	}
	
	exit (json_encode(array('status' => '2', 'data' => 'Не удалось удалить')));
}

if( $method == 'poll_add_function' )
{
	$name = checkJs($_POST['name'], null);
	
	if(empty($name)) {
		exit (json_encode(array('status' => '2', 'data' => 'Не указано название!')));
	}
	if(mb_strlen($name, 'UTF-8') > 128) {
		exit (json_encode(array('status' => '2', 'data' => 'Максимальное количество символов 128')));
	}
	
	include_once '../inc/classes/HTMLPurifier/HTMLPurifier.auto.php';
	
	$polls = $Purifier->purify($_POST['polls']);
	
	$count = count(json_decode( $polls, true ));
	
	if( $count < 1 ) {
		exit (json_encode(array('status' => '2', 'data' => 'Заполните хотя бы 1 вариант ответа')));
	}
	
	if(mb_strlen($polls, 'UTF-8') > 2048) {
		exit (json_encode(array('status' => '2', 'data' => 'Слишком много вариантов ответа')));
	}
	
	if( $pdo->query("INSERT INTO `poll`(`name`, `polls`) VALUES ('{$name}','{$polls}')") )
	{
		exit (json_encode(array('status' => '1', 'data' => 'Добавлено')));
	}
	
	exit (json_encode(array('status' => '2', 'data' => 'Не удача')));
}

if( $method == 'poll_edit_function' )
{
	$pollid = checkJs($_POST['pollid'], "int");
	if(empty($pollid)) {
		exit (json_encode(array('status' => '2', 'data' => 'Не корректно выбран опрос')));
	}
	
	$name = checkJs($_POST['name'], null);
	
	if(empty($name)) {
		exit (json_encode(array('status' => '2', 'data' => 'Не указано название!')));
	}
	if(mb_strlen($name, 'UTF-8') > 128) {
		exit (json_encode(array('status' => '2', 'data' => 'Максимальное количество символов 128')));
	}
	
	include_once '../inc/classes/HTMLPurifier/HTMLPurifier.auto.php';
	
	$polls = $Purifier->purify($_POST['polls']);
	
	$count = count(json_decode( $polls, true ));
	
	if( $count < 1 ) {
		exit (json_encode(array('status' => '2', 'data' => 'Заполните хотя бы 1 вариант ответа')));
	}
	
	if(mb_strlen($polls, 'UTF-8') > 2048) {
		exit (json_encode(array('status' => '2', 'data' => 'Слишком много вариантов ответа')));
	}
	
	if( $pdo->query("UPDATE `poll` SET `name`='{$name}',`polls`='{$polls}' WHERE `id` = {$pollid}") )
	{
		exit (json_encode(array('status' => '1', 'data' => 'Сохранено')));
	}
	
	exit (json_encode(array('status' => '2', 'data' => 'Не удача, попробуйте ещё раз!')));
}